/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.ethernet;

import com.gprinter.udp.CommandUDP;
import com.gprinter.udp.Response;
import com.gprinter.udp.ethernet.EthernetDeviceResp;
import com.gprinter.utils.LogUtils;
import java.util.HashMap;
import java.util.Map;

public class SearchDeviceCommand
extends CommandUDP {
    @Override
    public byte[] getCommand() {
        return new byte[]{66, 91, 93, 71};
    }

    @Override
    public Response resolveResponseData(long uuid, byte[] data) {
        try {
            Map<String, String> map = this.getResponseMap(data);
            if (map != null) {
                EthernetDeviceResp resp = new EthernetDeviceResp();
                resp.setId(map.get("ID"));
                resp.setDeviceName(map.get("DEVICENAME"));
                resp.setVersion(map.get("VER"));
                resp.setMfc(map.get("MFC"));
                resp.setSn(map.get("SN"));
                String mac = map.get("MAC").replace(" ", "");
                byte[] mac2 = new byte[]{(byte)mac.charAt(0), (byte)mac.charAt(1), 45, (byte)mac.charAt(2), (byte)mac.charAt(3), 45, (byte)mac.charAt(4), (byte)mac.charAt(5), 45, (byte)mac.charAt(6), (byte)mac.charAt(7), 45, (byte)mac.charAt(8), (byte)mac.charAt(9), 45, (byte)mac.charAt(10), (byte)mac.charAt(11)};
                resp.setMac(new String(mac2));
                resp.setDhcp(map.get("DHCP").equals("Enable"));
                resp.setDhcpTimeout(map.get("DTIMEOUT"));
                resp.setIp(map.get("IP"));
                resp.setNetmask(map.get("SUBNETWORK"));
                resp.setGateway(map.get("GATEWAY"));
                resp.setPrinterPort(Integer.valueOf(map.get("PRNPORT")));
                LogUtils.e("\u8fd4\u56de\u53c2\u6570\u89e3\u6790", resp.toString());
                return resp;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Map<String, String> getResponseMap(byte[] data) {
        String[] split;
        if (data == null || data.length < 1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String dat = new String(data);
        for (String s : split = dat.split(";")) {
            String[] sub;
            if (s.isEmpty() || (sub = s.split(":")).length < 2) continue;
            map.put(sub[0], sub[1]);
        }
        return map;
    }
}

